/*
 * Options for modeling byte transmission (uncomment at most 1)
 * - SUHDCHK_ZHD
 *   - Line is released (data=HiZ) after hold time
 * - SUHDCK_CKFE
 *   - Data is set during falling edge of CLK, line released at falling edge
 *     of CLK
 * - default (no option uncommented)
 *   - Data is set to 0 after hold time, line released (tCL-tSU) after
 *     last falling edge of CLK
 *
 */
//`define SUHDCHK_ZHD
`define SUHDCHK_CKFE
`timescale 100ps / 10ps
module stimulus 
	(
    IO,
    CLK1,
    CLK2,
		CS1n,
		CS2n,
    HBP,
    HTBSEL
	);

  /* SPI clock freq: high and low times */
  parameter tCH = 100;
  parameter tCL = 100;

  inout [7:0] IO;
	
	output CS1n, CS2n;
	output CLK1, CLK2;
  output reg [2:0] HBP = 3'b000;
  output reg HTBSEL = 0;
        
	reg CSn = 1;
	reg CLK = 0;
        
  reg L0_CSn;
  reg L1_CSn;
	reg L0_SI_IO0_reg=0;
  reg L0_SO_IO1_reg=0;
  reg L0_WPn_IO2_reg=0;
  reg L0_IO3_reg=0;
	reg L1_SI_IO0_reg=0;
  reg L1_SO_IO1_reg=0;
  reg L1_WPn_IO2_reg=0;
  reg L1_IO3_reg=0;

  reg [3:0] L0_tx, L1_tx;
  //reg [1:0] sel_dev;

  parameter SPI = 3'h1;
  parameter QPI = 3'h4;

  wire L0_SI_IO0;
  wire L0_SO_IO1;
  wire L0_WPn_IO2;
  wire L0_IO3;
  wire L1_SI_IO0;
  wire L1_SO_IO1;
  wire L1_WPn_IO2;
  wire L1_IO3;

  /* Register Addresses */
  localparam ADDR_SR  = 32'h0;
  localparam ADDR_ISR = 32'h1;
  localparam ADDR_CR1 = 32'h2;
  localparam ADDR_CR2 = 32'h3;
  localparam ADDR_INTCR = 32'h4;
  localparam ADDR_ECCDIR = 32'h5;
  localparam ADDR_ECCEIR = 32'h6;
  localparam ADDR_ECCDOR = 32'h7;
  localparam ADDR_ECCECR = 32'h8;
  localparam ADDR_ID  = 32'h30;
  localparam ADDR_UID = 32'h40;
  localparam ADDR_SN  = 32'h50;

  `include "task_DL.v"
  
  assign IO[0] = (L0_tx[0]) ? L0_SI_IO0_reg : 1'bz;  
  assign IO[1] = (L0_tx[1]) ? L0_SO_IO1_reg : 1'bz;  
  assign IO[2] = (L0_tx[2]) ? L0_WPn_IO2_reg : 1'bz;  
  assign IO[3] = (L0_tx[3]) ? L0_IO3_reg : 1'bz;  
  assign IO[4] = (L1_tx[0]) ? L1_SI_IO0_reg : 1'bz;  
  assign IO[5] = (L1_tx[1]) ? L1_SO_IO1_reg : 1'bz;  
  assign IO[6] = (L1_tx[2]) ? L1_WPn_IO2_reg : 1'bz;  
  assign IO[7] = (L1_tx[3]) ? L1_IO3_reg : 1'bz;  
  assign CLK1 = CLK;
  assign CLK2 = CLK;
  //assign CS1n = (sel_dev[0]==1'b1) ? L0_CSn : 1'b1;
  //assign CS2n = (sel_dev[1]==1'b1) ? L1_CSn : 1'b1;
  assign CS1n = L0_CSn;
  assign CS2n = L1_CSn;

  assign L0_SI_IO0  = IO[0];
  assign L0_SO_IO1  = IO[1];
  assign L0_WPn_IO2 = IO[2];
  assign L0_IO3     = IO[3];
  assign L1_SI_IO0  = IO[4];
  assign L1_SO_IO1  = IO[5];
  assign L1_WPn_IO2 = IO[6];
  assign L1_IO3     = IO[7];


  /* Initialize */
  initial begin
    L0_SI_IO0_reg = 0;
    L0_SO_IO1_reg = 0;
    L0_WPn_IO2_reg = 0;
    L0_IO3_reg = 0;
    L0_tx = 0;
    L0_CSn = 1'b1;
    L1_SI_IO0_reg = 0;
    L1_SO_IO1_reg = 0;
    L1_WPn_IO2_reg = 0;
    L1_IO3_reg = 0;
    L1_tx = 0;
    L1_CSn = 1'b1;
  end

  initial begin
    #10000;

    $display("==== [TEST] SPI/QPI Enable, Both lanes ====");
    DL_QPIEnable(SPI, 2'b11);
    DL_SPIEnable(QPI, 2'b11);
    
    $display("==== [TEST] Write Enable/Disable (SPI) ====");
    DL_WriteEnable(SPI, 2'b11);
    DL_WriteDisable(SPI, 2'b10);
    DL_WriteEnable(SPI, 2'b10);
    DL_WriteDisable(SPI, 2'b01);
    DL_WriteEnable(SPI, 2'b01);
    DL_WriteDisable(SPI, 2'b11);

    $display("==== [TEST] Read Any Register: ID (SPI) ====");
    DL_WriteEnable(SPI, 2'b11);
    DL_WriteReg(SPI, ADDR_CR2, 8'h08, 2'b11); // both lanes set latency=8
    DL_ReadReg(SPI, ADDR_ID, 8'd0, 8'd8, 2'b11); // read both lanes
    DL_ReadReg(SPI, ADDR_ID, 8'd0, 8'd8, 2'b01); // read lane 0
    DL_ReadReg(SPI, ADDR_ID, 8'd0, 8'd8, 2'b10); // read lane 1

    $display("==== [TEST] Write(02h)/Read(13h/03h) Both lanes (SPI) ====");
    DL_WriteEnable(SPI, 2'b11);
    DL_WriteSeq(SPI, 32'h2345, 16'ha0a0, 8'h1, 23'd16, 2'b11);
    DL_ReadSeq(SPI, 32'h2345, 16'ha0a0, 8'h1, 23'd16, 2'b11);
    DL_ReadSeq3byte(SPI, 24'h2345, 16'ha0a0, 8'h1, 23'd16, 2'b11);

    $display("==== [TEST] Write(02h)/Read(13h/03h) Single Lane (SPI) ====");
    DL_WriteEnable(SPI, 2'b11);
    DL_WriteSeq(SPI, 32'h3456, 16'ha0a0, 8'h1, 23'd16, 2'b11);
    DL_WriteEnable(SPI, 2'b01);
    DL_WriteSeq(SPI, 32'h3456, 16'hb0b0, 8'h2, 23'd16, 2'b01); // Overwrite Data in Lane 0
    DL_ReadSeq(SPI, 32'h3456, 16'ha0a0, 8'h1, 23'd16, 2'b11); // Expected Error in Lane 0
    DL_ReadSeq3byte(SPI, 24'h3456, 16'hb0b0, 8'h2, 23'd16, 2'b01);
    DL_ReadSeq(SPI, 32'h3456, 16'ha0a0, 8'h1, 23'd16, 2'b10);
    $finish;
  end
endmodule
